;			TRANSPOSITION 	[   O R C H E S T R A   ]
;------------------------------------------------------------------------------
;	APPLICATION POUR DES MODULATION REDUITES, DANS UN TAMPON DE LECTURE
;	(!) DEPASSEMENT DES BORNES DU TAMPON ==> RETOUR BRUSQUE A L'UNISSON
;------------------------------------------------------------------------------

; enonces generaux . . .
	sr = 32000				; taux d'ech. audio : 32000
	kr = 32000				; taux d'ech. controle : 32000
	ksmps = 1				; = sr/kr 
	nchnls = 1				; "mono"

; instrument auxiliaire, pour ecoute du spectre original (f3)
	instr 2
		kenv	oscil1i 0,ampdb(90+p4),p3, 2
		aout	oscili	kenv,p5, p6
			out	aout
	endin

; instrument auxiliaire, pour ecoute du son pre-enregistre original
	instr 3
		a1	soundin	p4		; voix = fichier soundin.1
			out	a1
	endin

; instrument 4 :	a pour fonction de fournir les echantillons a moduler,
;			dans la variable "gatobe"
;		Programmation generale (PEU EFFICACE), pour fins pedagogiques :
;			cas1 : p4>0  ==> lira le fichier "soundin.(p4)"
;			cas2 : p4<=0 ==> sortira le spectre p6, sous enveloppe
;					 p7, avec intensite p4 et frequence p5
	instr 4
		if	p4 > 0 goto cas1
		cas2:	kenv	oscil1i	0,ampdb(90+p4),p3, p7	; env. p7
			ain	oscili kenv,p5, p6		; spect. p6
			goto fin
		cas1:	ain	soundin p4			; lecture brute
		fin:	gatobe = ain
	endin

; instrument 5 :	a pour fonction de fournir les intervalles de
;			modulation dans la variable "gkintrv"
;			EXEMPLE : vibrato  :	amplitude	p4 demi-tons
;						frequence	p5 Hz
;						forme d'onde	p6
; (!) DOIT ETRE LANCE AVEC UNE SECONDE DE RETARD
	instr 5
		gkintrv	oscili p4,p5, p6
	endin

; instrument 6 :	recoit les echantillons dans "gatobe"
;			recoit son controle dans "gkintrv", en nombre de
;			demi-ton (-12 ==> octave grave ; 12 ==> octave aigue)
;			sort la modulation dans "gatrnsp"
; DEPASSEMENT DES BORNES DU TAMPON ==> RETOUR BRUSQUE A L'UNISSON
; SONNE AVEC UNE SECONDE DE RETARD, donc aussi UNE SECONDE PLUS TARD
	instr 6
		; initialisations
			ilogdeu	= log(2.0)
			imax	= 1.5		;longueur du tampon de lecture
			kdresse	init 1.0	;adresse de lecture dans tampon
			gkintrv init 0.0	;int. trnsp. par defaut = 0 d.t.
		; CALCUL : les deux enonces conditionnels obligent l'adresse
		; theorique "kdresse" et l'adresse reelle "kreel", ainsi que
		; l'intervalle de transposition "gkintrv" et la vitesse deduite
		; "kvitss" a etre des variables de controle (de type "k...")
			abidon	delayr imax
			kvitss	= exp((gkintrv/12.0)*ilogdeu)
			kdresse	= kdresse+((-kvitss+1)/kr)	    ;adr. theor.
			kreel	= ((kdresse < 0.0) ? 0.0 : kdresse) ;-->reelle
			kreel	= ((kreel > imax) ? imax : kreel)   ;dns[0,imax]
			gatrnsp	deltapi kreel
				delayw gatobe
	endin

; instrument 7 :	recoit et sort la modulation "gatrnsp"
;		Configuration generale (PEU EFFICACE), pour fins pedagogiques
; SONNE AVEC UNE SECONDE DE RETARD, donc aussi UNE SECONDE PLUS TARD
	instr 7
			out gatrnsp
	endin
