;;; Ce fichier peut tre charg. Il comporte, dans son corps, des exemple 
;;; valuer manuellement. Il utilise des fonctions dfinies dans le fichier
;;; 2p2z*

;;   Rappel du fichier 2p2z* : signaux alimentant le filtre
;;   Visualisation des composantes spares
;;    (continu (ligne (* amG (sin (incf angG pasG)))))      ;grave
;;    (continu (ligne (* amM (sin (incf angM pasM)))))      ;moyenne
;;    (continu (ligne (* amA (sin (incf angA pasA)))))      ;aige
;;   Visualisation de la somme des trois
;;    (continu (ligne (eval mix)))                          ;mixage

;; ATTENTION LispWorks : NE PAS VALUER LA FONCTION
;;    CONTINU
;; qui commande les appels "graphiques" 
;;    tourne
;; elle-mme appelant la fonction "graphique"
;;    ligne
;; DANS UNE FENTRE EDITOR ==> ON PERD LA MAIN !
;; ==> COPIER LES LIGNES DSIRES DANS LISTENER !!!
;; ==> VALUER DANS LISTENER !!!

;; N.B. : - cliquer bouton Break pour figer le dfilement
;;        - :c 1 ou bouton Continue pour reprendre
;;        - q pour arrter dfinitivement

;;; Filtre universel de PDG (Pepino di Giugnio), cf. fonction 4X
;;; difil(input,fre,alpha,amp)

(defclass PDGu (filtre)
  ((hi :initarg :hi) (bp :initarg :bp) (lo :initarg :lo)
   (fre :initarg :fre) (alpha :initarg :alpha) (amp :initarg :amp)
   (f1 :initarg :f1)
   (connect :initarg :connect))
  (:default-initargs :hi 0 :bp 0 :lo 0
                     :fre 0 :alpha 0 :amp 0
                     :f1 0
                     :connect nil))

;;   Traitement d'un chantillon <xn> par l'instance de PDGu nomme <flt>.
;; Le champ <connect> de <flt> contient le nom du champ  (hi, lo ou bp) que
;; l'on dsire utiliser, i.e. connecter au champ de sortie <yn>.
(defmethod traite ((flt PDGu) xn)
  (reinitialize-instance flt :hi (- (* (slot-value flt 'amp)
                                       xn)
                                    (slot-value flt 'f1)))
  (reinitialize-instance flt :bp (+ (* (slot-value flt 'fre)
                                       (slot-value flt 'hi))
                                    (slot-value flt 'bp)))
  (reinitialize-instance flt :lo (+ (* (slot-value flt 'fre)
                                       (slot-value flt 'bp))
                                    (slot-value flt 'lo)))
  (reinitialize-instance flt :f1 (+ (* (slot-value flt 'alpha)
                                       (slot-value flt 'bp))
                                    (slot-value flt 'lo)))
  (reinitialize-instance flt :yn (slot-value flt (slot-value flt 'connect))))

;;   Configuration passe-bas (low-pass) : utilise la sortie 'lo
(defparameter PDGlo
  (make-instance 'PDGu :fre (freq 3000) :alpha 0.5 :amp 0.5 :connect 'lo))
;    (continu (tourne mix PDGlo))                       ;passe-bas

;;   Configuration passe-bande (band-pass) : utilise la sortie 'bp
(defparameter PDGbp
  (make-instance 'PDGu :fre (freq 1000) :alpha 0.9 :amp 0.6 :connect 'bp))
;    (continu (tourne mix PDGbp))                       ;passe-bande

;;   Configuration passe-haut (high-pass) : utilise la sortie 'hi
(defparameter PDGhi
  (make-instance 'PDGu :fre (freq 600) :alpha 0.5 :amp 0.6 :connect 'hi))
;    (continu (tourne mix PDGhi))                       ;passe-haut

