;;; Algorithmes de filtres simples du premier ordre

;;; Ce fichier peut tre charg. Il comporte, dans ses dernires lignes, des
;;; exemple  valuer manuellement.

;; Variables et fonction pour une sortie "graphique".

(defparameter chaine (make-string 80 :initial-element #\ ))
(defun ligne (num &key (max 79) &aux indx)
  (setq indx (round (+ (* (+ num 1.0) (/ max 2.0)) (/ (- 79.0 max) 2.0))))
  (if (> indx 79) (incf indx -79)
      (when (minusp indx) (incf indx 79)))
  (setf (aref chaine 40) #\|)
  (setf (aref chaine indx) #\*)
  (format t "~A~%" chaine)
  (dotimes (n 1000) (eval t))            ;perte de temps... <-- RGLAGE VITESSE
  (setf (aref chaine indx) #\ ) 'ok)
(defun dessin (li)
  (format t "~%                <-----------------------0----------------------->~%")
  (dolist (n li) (ligne (/ n 100.0) :max 200))
  (format t "                                        V~%"))

;;   Filtre passe-bas simple. Exemple de [STEIGLITZ, K, 1974 : An Introduction
;; to Discrete Systems, Wiley : 50 sq.] - "moving average simple filter". Aussi
;; quivalent  [SMITH, J. O. III, 1981 : Introduction to Digital Filter Theory,
;; CCRMA : 4 sq.] - "simplest (and by no means ideal) low-pass filter".

(defun SteiglitzH (li)
  (let ((kdr (cdr li)))
    (if (endp kdr) nil
    (cons (/ (+ (car kdr) (car li)) 2.0) (SteiglitzH kdr)))))

;;   Filtre passe-haut simple. Exemple de [STEIGLITZ, op. cit. : 56-57] -
;; second exemple de "moving average simple filter".

(defun SteiglitzG (li)
  (let ((kdr (cdr li)))
    (if (endp kdr) nil
    (cons (/ (- (car kdr) (car li)) 2.0) (SteiglitzG kdr)))))

;;   Filtre passe-bas simple, d'aprs un exemple de [MOORE, R., 1978 : "An
;; Introduction to the Mathematics of Digital Signal Processing (Part II)",
;; CMJ (2)2 : 56] - "simplest [...] first-order LPF". N.B. : modifi.

(defun MooreLP (li &optional (yn-1 0))
  (if (endp li) nil
  (cons (setq yn-1 (+ (/ (car li) 2.0) yn-1))
        (MooreLP (cdr li) yn-1))))

;;   Filtre passe-haut simple. Signal d'entre moins filtre passe-bas de Moore
;; ci-dessus.

(defun MooreHP (li &optional (yn-1 0))
  (if (endp li) nil
  (let ((xn (car li)))
    (cons (- (setq yn-1 (+ (/ xn 2.0) yn-1)) xn)
          (MooreHP (cdr li) yn-1)))))

;; Signal cobaye thorique de 17 chantillons : <signal>.
;; Mme signal cobaye bruit avec des modulations alatoires : <bruite>.

(defparameter signal '(-12  -6 2 4 6 0 -2 -4  0  2  6  8 12 14 14 10  6))
(defparameter bruite '(-14 -10 6 2 4 6 -6  0 -2 -2 12 10  6 12 14  4 10))

;;; Exemples  valuer manuellement...

;;   Visualisation des signaux d'entre et application des filtres au cobaye
;; bruit avec sortie "graphique" simple.

; (dessin signal)              ; signal cobaye thorique
; (dessin bruite)              ; signal cobaye bruit
; (dessin (SteiglitzH bruite)) ; passe-bas de Steiglitz et Smith
; (dessin (SteiglitzG bruite)) ; passe-haut de Steiglitz
; (dessin (MooreLP bruite))    ; passe-bas de Moore
; (dessin (MooreHP bruite))    ; entre - passe-bas de Moore


;;   Ci-dessous les deux filtres d'aprs Moore, mais sans modification.
;; Rsultats de qualit infrieure...

(defun MooreLP1 (li &optional (yn-1 0))
  (if (endp li) nil
  (cons (setq yn-1 (+ (car li) (/ yn-1 2.0)))
        (MooreLP1 (cdr li) yn-1))))
(defun MooreHP1 (li &optional (yn-1 0))
  (if (endp li) nil
  (let ((xn (car li)))
    (cons (- (setq yn-1 (+ xn (/ yn-1 2.0))) xn)
          (MooreHP1 (cdr li) yn-1)))))

; (dessin (MooreLP1 bruite))    ; passe-bas de Moore
; (dessin (MooreHP1 bruite))    ; entre - passe-bas de Moore
