;;   Comparaison entre
;;    <A> distributions et phnomnes stochastiques classiques, dots d'une
;;        moyenne (esprance mathmatique) et conformes  la loi des grands
;;        nombres, et
;;    <B> distributions  "longue trane" ou  "queue paisse" (Fat Tail), sans
;;        esprance mathmatique et non conformes  la loi des grands nombres --
;;        par exemple la distribution de Cauchy
;; Cf. [DELAHAYE, Jean-Paul, 2010 : "Faire fortune avec les longues tranes",
;; Dossier Pour la science no 66, L're d'internet : 102 sq.].

;;; <A>

;;   Exemple "classique" : avec moyenne et conforme  la loi des grand nombres.
;; Des entiers alatoires sont tirs dans [1,<n>] en squence, jusqu' ce qu'un
;; 1 soit tir. On rend alors la SOMME des entiers de la squence.
;;    Ex. : (pressebouton (print (S 10))) ou (pasapas (print (S 10)))

(defun S (n)
  (let ((x (1+ (random n))))
    ;(print x)
    (if (= x 1) '1
      (apply #'+ (cons x (list (S n)))))))

;;   Moyenne de (S <n>) sur <nbr> squences. La moyenne est
;;    <n>*(<n>+1)/2
;; [ibid. : 102], et l'augmentation de <nbr> produit des rsultats convergeant
;; vers cette valeur thorique [ibid. : Fig. a, p. 104].
;;    Ex. : (pressebouton (MoyS 10 1000)) ou (pasapas (MoyS 10 1000))

(defun MoyS (n nbr)
  (format t "~&Moyenne theorique = ~D~%" (/ (* (1+ n) n) 2.0))
  (let ((somme 0))
    (dotimes (m nbr (progn
                      (format t "Moy. obtenue sur ~D tirages =~%" nbr)
                      (format t "rationnelle ~D~%" (/ somme nbr))
                      (format t "double-prec ~D" (float (/ somme nbr) 0.0D0))))
      ;(incf somme (print (S n))))))
      (incf somme (S n)))))

;;; <B>

;;   Exemple  "longue trane" : moyenne infinie, non conformit  la loi des
;; grands nombres. Des entiers alatoires sont tirs dans [1,<n>] en squence,
;; jusqu' ce qu'un 1 soit tir. On rend alors le PRODUIT des entiers de la
;; squence.
;;    Ex. : (pressebouton (print (P 10))) ou (pasapas (print (P 10)))

(defun P (n)
  (let ((x (1+ (random n))))
    ;(print x)
    (if (= x 1) '1
      (apply #'* (cons x (list (P n)))))))

;;   Moyenne de (P <n>) sur <nbr> squences. La moyenne tant infinie [ibid. :
;; 103], l'augmentation de <nbr> produit des rsultats de plus en plus
;; divergents [ibid. : Fig. b, p. 104].
;;    Ex. : (pressebouton (MoyP 10 1000)) ou (pasapas (MoyP 10 1000))

(defun MoyP (n nbr)
  (format t "~&Pas de moyenne theorique~%")
  (let ((somme 0))
    (dotimes (m nbr (progn
                      (format t "Moy. obtenue sur ~D tirages =~%" nbr)
                      (format t "rationnelle ~D~%" (/ somme nbr))
                      (format t "double-prec ~D" (float (/ somme nbr) 0.0D0))))
      ;(incf somme (print (P n))))))
      (incf somme (P n)))))
