;;; Cf. Thomas NOLL (Escola Superior de Musica de Catalunya), 2008 : *Sturmian
;;; Sequences and Morphisms: A Music-Theoretical Application*, confrence,
;;; Journe annuelle de la Socit mathmatique de France, "Mathmatique et
;;; musique", Institut Henri Poincar, Paris, 21 juin.

;;   Extrait du rsum :
;; << Many properties of the mechanical word
;;    s = ([(n+1)g] - [ng]), n = 0, 1, 2,...
;; (where [ ] denotes the integral part) play a strikingly illuminating role in
;; music theory when
;;    g = log2(3/2)
;; This number represents the pitch heigth ration between the musical intervals
;; fifth and octave. The word s exemplifies the discrete rendering of the kernel
;; of the linear pitch heigth form
;;    p(m,n) = gm+n
;; on the Pythagorean tone lattice, which is the free Z-module of all linear
;; combinations of these two intervals. [...] >>

;;   Fonction incarnant la dfinition ci-dessus. N.B. :
;;    (log 3/2 2) = 0.5849625007211562

(defun gg (n)
  (- (truncate (* (1+ n) (log 3/2 2))) (truncate (* n (log 3/2 2)))))

;; Ex. pour voir...
; (dotimes (n 3333) (princ (gg n)))

;; Idem,  48 chiffres par ligne : montre des symtries et changements
; (dotimes (n 3333) (when (zerop (mod n 48)) (terpri)) (princ (gg n)))

;; Idem,  12 chiffres par ligne : montre des symtries et changements
; (dotimes (n 3333) (when (zerop (mod n 12)) (terpri)) (princ (gg n)))

;; Idem,  4 chiffres par ligne : montre des symtries et changements
; (dotimes (n 555) (when (zerop (mod n 4)) (terpri)) (princ (gg n)))

;; Idem,  2 chiffres par ligne : montre des symtries et changements
; (dotimes (n 333) (when (zerop (mod n 2)) (terpri)) (princ (gg n)))

;;   Version CLOS

(defclass sturmian ()
  ((n :initarg :n)
   (g :initarg :g))
  (:default-initargs :n -1
                     :g '(log 3/2 2)))

(defmethod laisse ((obj sturmian))
  (let ((n (1+ (slot-value obj 'n)))
        (g (eval (slot-value obj 'g))) )
    (reinitialize-instance obj :n n)
    (- (truncate (* (1+ n) g)) (truncate (* n g)))))

;;   Exemple.

(defparameter o1 (make-instance 'sturmian))
; (dotimes (n 3333) (when (zerop (mod n 48)) (terpri)) (princ (laisse o1)))