;;; Canons stochastiques ncessitant la mise en oeuvre d'algorithmes

;; Gestion du module "canons-stochastiques", ncessaire pour la fonction
;; init-random (ainsi que frandom, si utilise).

(when (not (boundp 'common-lisp::*path-stochastique*))
	(setq common-lisp::*path-stochastique* (pathname ""))
	(format *error-output*
		"Attention : le path common-lisp::*path-stochastique* est nul :~
		~%~12Terreur(s) fichier(s) possible(s)."))
(require "canons-stochastiques"
	(merge-pathnames "canons_base.lisp" common-lisp::*path-stochastique*))

(defun gauss (mu sigma)
"
;    gauss <mu> <sigma> => reel de distribution Gauss-Laplace de moyenne <mu>
;                          et d'ecart type <sigma>
"
  (let ((s 0.0))
    (dotimes (cte 12 (+ (* (- s 6.0) sigma) mu))
      (setq s (+ s (random 1.0))))))

(defun beta (a b)
"
;     beta <a> <b> => variable de distribution Beta(<a>,<b>) dans ]0,1[
"
  (let ((ea (/ a))
        (eb (/ b))
        (y1 1.0)
        (y2 1.0))
    (do	((s 2.0 (+ y1 y2)))
        ((<= s 1.0) (/ y1 s))
      (setq y1 (expt (random 1.0) ea))
      (setq y2 (expt (random 1.0) eb)))))

(defun cobeta (a b r1 r2)
"
;    cobeta <a> <b> <r1> <r2> => reel dans ]<r1>,<r2>[, selon distribution
;                                Beta(<a>,<b>)
"
  (+ r1 (* (- r2 r1) (beta a b))))

;;   "Documentation".

(setq Doc.Stoch (concatenate 'string Doc.Stoch
                                     (format nil ";; canons_algo
;    gauss <mu> <sigma>	       => Gauss-Laplace moy. <mu> ecart type <sigma>
;    beta <a> <b>	       => Beta(<a>,<b>) dans ]0,1[
;    cobeta <a> <b> <r1> <r2>  => Beta(<a>,<b>) dans ]<r1>,<r2>[
")))

;(format t "~A" Doc.Stoch)
