;;; Fonctions de base pour les canons stochastiques

;;   Pour que les documentation-string soient prises en compte. Fait ici
;; ventuellement double emploi avec +clinit.cl.

(setq *save-doc-strings* t)

;;   Conserver le germe initial pour utilisation ultrieure...

(defvar common-lisp::*germe-initial* (make-random-state))

;; Continue uniforme dans [0,1[
;;	frandom	=>	rend un float dans [0,1[
;(defun frandom ()
;	(float (/ (random most-positive-fixnum) most-positive-fixnum)))
;; N.B. : MACINTOSH. Pour des raisons d'efficacit nettement suprieure, je
;;        n'utilise pas frandom telle que dfinie ici : tous les appels
;;        (frandom) sont remplacs dans les fichiers concerns par (random 1.0).
;;        Ca tourne 4.855 fois plus vite...

;;   Initialisation et contrle du germe alatoire.

(defun init-random (&optional (n nil))
"
;   Initialisation (interactive ou non) du germe aleatoire. Dans tous les cas,
; retourne le nouveau germe defini.
;    init-random &optional <n> => initialisation de *random-state* selon <n> :
;        <n> absent ou nil => sequence interactive
;        <n> = 0           => initialisation standard : retour au germe initial
;        <n> nombre /= 0   => initialisation aleatoire (selon date et heure...)
;        si <n> est un objet de type random-state, il est utilise comme germe
; Exemples de valeurs possibles pour <n> dans ce dernier cas :
;    #S(random-state :seed <un-grand-entier-positif>) donne textuellement, ou
;    (make-random-state <variable-contenant-un-random-state>)
"
  (cond
   ((numberp n)
    (if (zerop n)
      (setq *random-state* (make-random-state
                            common-lisp::*germe-initial*))
      (setq *random-state* (make-random-state t))))
   ((random-state-p n)
    (setq *random-state* (make-random-state n)))
   ((null n)
    (format *query-io*
            "~%Type d'initialisation du germe :~%~
             0~30T=> retour au germe initial~%~
             nombre /= 0~30T=> aleatoire (selon date et heure...)~%~
             objet de type random-state~30T=> initialisation a ce germe~%~
             init-random ? ")
    (init-random (eval (read))))
   (t
    (cerror "continuer en donnant un nouvel argument d'appel ~
             a init-random. Pour plus de details, faire ~
             (documentation 'init-random 'function)"
            "Mauvais argument d'appel : ~A."
            n)
    (init-random))))

;;   Gestion du module "canons-stochastiques".
(provide "canons-stochastiques")

;;   "Documentation".

(when (boundp 'Doc.) (setq Doc. (concatenate 'string Doc. ", Doc.Stoch")))
(when (not (boundp 'Doc.Stoch)) (defparameter Doc.Stoch ""))
(setq Doc.Stoch (concatenate 'string Doc.Stoch (format nil "~&;; canons_base
;    common-lisp::*germe-initial* := ~S
;    init-random [(<n> nil)]   := nil => interact. ; 0 => initial ; /=0 => alea.
;    Doc.Stoch  (symb.)        => ceci... et davantage, selon canons charges
" common-lisp::*germe-initial*)))

;(format t "~A" Doc.Stoch)
