;;; Canons stochastiques de variables alatoires de types divers

;;   Gestion du module "canons-stochastiques", ncessaire pour la fonction
;; init-random (ainsi que frandom, si utilise).

(when (not (boundp 'common-lisp::*path-stochastique*))
	(setq common-lisp::*path-stochastique* (pathname ""))
	(format *error-output*
		"Attention : le path common-lisp::*path-stochastique* est nul :~
		~%~12Terreur(s) fichier(s) possible(s)."))
(require "canons-stochastiques"
	(merge-pathnames "canons_base.lisp" common-lisp::*path-stochastique*))

(defun linea (g)
"
;    linea <g> => variable de distribution lineaire dans ]0,<g>[
"
  (* g (- 1.0 (sqrt (random 1.0)))))

(defun cauchy (tau iopt)
"
;    cauchy <tau> <iopt>, ou <iopt> doit etre un nombre
;        => variable de distribution Cauchy de dispersion <tau>
;            <iopt>=1  => uniquement des variables positives
;            <iopt>/=1 => variables Cauchy normales de -oo a +oo
"
  (let ((u (random 1.0)))
    (when (= 1 iopt) (setq u (/ u 2.0)))
    (setq u (* (float pi 1.1) u))
    (* tau (/ (sin u) (cos u)))))

(defun coshyper (tau)
"
;    coshyper <tau> => variable de distribution cosinus hyperbolique de mode 0.0
;                      ou <tau> est un coefficient de dispersion
"
  (* tau (log (tan (* pi (random 1.0) 0.5)))))

(defun logist (a b)
"
;    logist <a> <b> => variable de distribution logistique de mode -<b>/<a>,
;                      avec coefficient de dispersion <a>
"
  (/ (- (- b) (log (- (/ 1.0 (random 1.0)) 1.0))) a))

;;   "Documentation".

(setq Doc.Stoch (concatenate 'string Doc.Stoch
                                     (format nil ";; canons_dive
;    linea <g>	               => lineaire dans ]0,<g>[
;    cauchy <tau> <i>          => Cauchy disp. <tau> ; <i>=1 => ]0,oo[ ; <i>/=1 => ]-oo,oo[
;    coshyper <tau>            => cosinus hyperbolique mode 0.0, disp. <tau>
;    logist <a> <b>            => logistique mode -<b>/<a>, disp. <a>
")))

;(format t "~A" Doc.Stoch)