;;; Canons stochastiques de variables alatoires de type exponentiel

;;   Gestion du module "canons-stochastiques", ncessaire pour la fonction
;; init-random (ainsi que frandom, si utilise).

(when (not (boundp 'common-lisp::*path-stochastique*))
	(setq common-lisp::*path-stochastique* (pathname ""))
	(format *error-output*
		"Attention : le path common-lisp::*path-stochastique* est nul :~
		~%~12Terreur(s) fichier(s) possible(s)."))
(require "canons-stochastiques"
	(merge-pathnames "canons_base.lisp" common-lisp::*path-stochastique*))

(defun expon (delta)
"
;    expon <delta> => variable de distribution exponentielle de densite <delta>
"
  (/ (- (log (random 1.0))) delta))

(defun gamma (nu)
"
;    gamma <nu> => variable de distibution gamma(<nu>). <nu> doit etre entier,
;                  ou sera tronque
"
  (let ((som 1.0))
    (dotimes (cpt (floor nu) (- (log som)))
      (setq som (* som (random 1.0))))))

(defun plapla (mu tau)
"
;    plapla <mu> <tau> => variable de distribution Premiere de Laplace, ajustee
;                         a la moyenne <mu>, et de dispersion <tau>
"
  (let ( (y (* 2.0 (random 1.0)))
         (fotau tau))
    (when (> y 1.0) (setq y (- 2.0 y))
                    (setq fotau (- tau)))
    (+ (* fotau (log y)) mu)))

;;   "Documentation".

(setq Doc.Stoch (concatenate 'string Doc.Stoch
                                     (format nil ";; canons_expo
;    expon <delta>             => exponentielle densite <delta>
;    gamma <nu>                => gamma(<nu>) ; <nu> entier, ou sera tronque
;    plapla <mu> <tau>         => premiere de Laplace moy. <mu>, disp. <tau>
")))

;(format t "~A" Doc.Stoch)