;;; Canons stochastiques de variables alatoires de type rectangulaire

;;   Gestion du module "canons-stochastiques", ncessaire pour la fonction
;; init-random (ainsi que frandom, si utilise).

(when (not (boundp 'common-lisp::*path-stochastique*))
	(setq common-lisp::*path-stochastique* (pathname ""))
	(format *error-output*
		"Attention : le path common-lisp::*path-stochastique* est nul :~
		~%~12Terreur(s) fichier(s) possible(s)."))
(require "canons-stochastiques"
	(merge-pathnames "canons_base.lisp" common-lisp::*path-stochastique*))

(defun inrect (i1 i2)
"
;    inrect <i1> <i2>, ou <i1> < <i2>, et tous deux sont des entiers
;        => un entier entre <i1> et (<i2>-1) i.e. dans [<i1>,<i2>[
"
  (+ i1 (random (- i2 i1))))

;;   Rend une liste de <lng> nombres entiers sans doublons dans [<i1>,<i2>[, o
;; <lng> doit tre suprieur ou gal  <i2>-<i1>. Lorsque <lng>=<i2>-<i1>,
;;    (inrect-no-dupl <n> <m> <m>-<n>)
;; quivaut  une permutation de la liste des entiers compris dans [<i1>,<i2>[.

(defun inrect-no-dupl (i1 i2 lng &aux rez tmp)
"    inrect-no-dupl <i1> <i2> <lng>, ou <i1> < <i2>, tous deux entiers, ainsi
    que <i2>-<i1> >= <lng>
        => liste de <lng> entiers dans [<i1>,<i2>[, sans doublons (differents)
"
  (when (> lng (- i2 i1))
         (error "inrect-no-dupl : longueur non realisable dans [~D,~D[ : ~D."
                i1 i2 lng))
  (labels ((interne (n)
             (cond ((zerop n) rez)
                   ((member (setq tmp (inrect i1 i2)) rez) (interne n))
                   (t (push tmp rez)
                      (interne (1- n))))))
    (interne lng)))

(defun corect (r1 r2)
"
;    corect <r1> <r2>, ou <r1> < <r2>, et tous deux sont des reels
;        => un reel dans [<r1>,<r2>[
"
  (+ r1 (* (- r2 r1) (random 1.0))))

;;   "Documentation".

(setq Doc.Stoch (concatenate 'string Doc.Stoch
                                     (format nil ";; canons_rect
;    inrect <i1> <i2>          => entier dans [<i1>,<i2>[
;    inrect-no-dupl <i1> <i2> <lng> => liste de <lng> entiers dans [<i1>,<i2>[
;    corect <r1> <r2>          => reel dans [<r1>,<r2>[
")))

;(format t "~A" Doc.Stoch)