;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;    Dmo de promenade alatoire par incrmentation d'une valeur par
;;    +1 ou -1 quiprobablement -- si random est "juste" ! -- elle semble
;;    avoir tendance  favoriser -1...
;;
;;    NE PAS CHARGER ... provoque des appels
;;        (continu...
;;    UTILISER MANUELLEMENT EN CUT/PASTE SOURIS...
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;   Une fonction imprime une *  la position horizontale donne par l'argument
;; d'appel <num>, dans [0,<largr>]. Par exemple :
;;    (ligne  0) => "*                                          	etc. "
;;    (ligne 46) => "                                          *	etc. "
;; La <largeur> de la ligne doit tre prvue selon celle de la fentre. Un trait
;; vertical | marque en outre le milieu de la ligne, en position <mpoz>.

;;   Impression d'une ligne avec l'* en position <num>, et remise en tat de la
;; chane vierge. En cas de dbordement hors de [0,<largr>], on imprime la
;; distance de <num>, par rapport  l'une ou l'autre bordure de la fentre, au
;; lieu d'une ligne normale avec * et |. Ceci permet de suivre les dplacements
;; de l'*, mme "en dehors" de la fentre. Deux variables globales, <mini> et
;; <maxi>, conservent les valeurs extrmes atteintes au cours de l'exprience.

(defun ligne (num)
  (if (> num maxi) (setq maxi num)
    (when (< num mini) (setq mini num)))
  (cond	((> num largr) (format t tabdrt (- num largr)))
        ((< num  0) (format t  "<~6D~%" num))
        (t	(setf (aref chaine num) #\*)
                (format t "~A~%" chaine)
                (setf (aref chaine num) (if (= num mpoz) #\| #\ ))))
  'ok)

;;   Appel d'impression d'une ligne avec l'* en position <poz>, et icrmentation
;; de <poz> de +1 ou -1 quiprobablement -- pour la prochaine ligne.

(defun pas-alea ()
  (ligne poz)
  (incf poz (if (zerop (random 2)) -1 1)))

;;   Utilisation type :

;; <1>	Initialisation : ligne vierge et mise de <poz> au milieu

(defparameter largeur 360)  ; <= LW 2010 : taille de police 9 pour cette largeur
(defparameter largr (- largeur 1))
(defparameter tabdrt (concatenate 'string "~"
                                  (prin1-to-string (- largeur 2))
                                  "D >~%"))
(defparameter chaine (make-string largeur :initial-element #\ ))
(defparameter mpoz (- (/ largeur 2) 1))
(defparameter poz mpoz)
(defparameter mini poz)
(defparameter maxi poz)
(setf (aref chaine poz) #\|)

;; <2> Lancement du processus rptitif

(continu (pas-alea))

;;   On peut interrompre (continu..., consulter les valeurs de <mini> et <maxi>,
;; puis relancer le processus par
;;    (continu (pas-alea))
;; sans rinitialiser avec <1> ci-dessus.

;;   Dj vu revenir de -1100 et davantage, pour regagner l'intrieur de la
;; fentre, et mme dborder de plus de 100  droite, repartir en dehors vers la
;; gauche, jusqu' -3300, en une vingtaine heures...  partir de la position de
;; dpart 39 les extrmes atteints en 112 h. (4.6 jours) ont t -3355 et +953
;; -- et peut-tre plus que 953, d'ailleurs : le processus tait arrt sur une
;; erreur de pile LISP, et je n'ai pu que voir cette valeur dans la fentre !
;;   Autre essai (9 h.) : les extrmes atteints ont t -2874 et +75, finissant
;; sur -1296, avec toute la dure passe du ct ngatif, autant que je sache,
;; sauf une ou deux minutes au dbut... : l'appel (random 2) semble donc bien
;; tre biais vers 0 !!!
;;   Autre essai, avec (init-random...  partir de l'heure, position de dpart
;; 39. Les extrmes atteints en 29h ont t -2171 et +2049 en finissant sur
;; -950 avec beaucoup de temps pass d'un ct comme de l'autre : nettement
;; plus quilibr...
