;;   Gestion du module "canons-stochastiques", ncessaire pour la fonction
;; init-random (ainsi que frandom, si utilise).

(when (not (boundp 'common-lisp::*path-stochastique*))
	(setq common-lisp::*path-stochastique* (pathname ""))
	(format *error-output*
		"Attention : le path common-lisp::*path-stochastique* est nul :~
		~%~12Terreur(s) fichier(s) possible(s)."))
(require "canons-stochastiques"
	(merge-pathnames "canons_base.lisp" common-lisp::*path-stochastique*))

(defun wurfel ()
"
;   Pour simuler le jet de deux des - normalement dans [2,12], mais ici decale
; dans [0,10].
"
  (+ (random 6) (random 6)))

;;   Histogramme thorique :
;;    Valeur jet ds :  2  3  4  5  6  7  8  9 10 11 12
;;        Prob./36 : #( 1  2  3  4  5  6  5  4  3  2  1 )

(defun tstwurfel (nbr)
  ;(format t "   2   3   4   5   6   7   8   9   10  11  12~%")
  (let ((table (make-array 11
                 :initial-contents
                   (make-list 11 :initial-element 0))))
    (dotimes (x nbr table)
      (incf (aref table (wurfel))))))

;;   "Documentation".

(setq Doc.Stoch (concatenate 'string Doc.Stoch
                                     (format nil ";; wurfel
;    wurfel                    => simul. deux des dans [0,10] -- normalement [2,12]
")))

(format t "~A" Doc.Stoch)
