;;   Pour arrondi infaillible. Procd alphanumrique, et non arithmtique. Ces
;; derniers procds - comme trimfloat4 et trimfloatx de +clinit.cl - laissent
;; parfois passer de trs petites parties dcimales en MCL. Tout repose sur la
;; directive de formatage "~m,nF" qui, elle, arrondit intelligemment et sans
;; failles. Cependant, on n'chappe pas aux limitations ordinaires de la
;; reprsentation de type float pour les trs grand et trs petits nombres.
;;   L'argument optionnel <dec> spcifie le nombre maximal de chiffres aprs le
;; point dcimal. Ce doit tre un entier > 0.
;;   Exemples :
;;    (trmfltx 987654.3756789)            => 987654.3757
;;    (trmfltx 987654.3756789 1)          => 987654.4
;;    (trmfltx 987654.3756789 6)          => 987654.375679
;;    (trmfltx 987654.3756789 5)          => 987654.37568
;;    (trmfltx 98765434567876549.6540185) => 9.876543456787654E+16
;;    (trmfltx 4.4 6)                     => 4.4
;;    l'intrieur de la fonction trmfltx, il est inutile de contrler la
;; longueur totale de la chane de caractres (chiffres et "."), car format
;; l'ignore si jamais elle s'avre trop courte pour le nombre  reprsenter.
;; Fixe arbitrairement  12, cette longueur n'a, en tous cas, aucun effet 
;; l'extrieur de la fonction.
;;   Pour la fonction int>string : cf. ped.14.

(defun trmfltx (nbr &optional (dec 4))
  (nth-value 0 (read-from-string (format nil
                                         (concatenate 'string "~12,"
                                                              (int>string dec)
                                                              "F")
                                         nbr))))
