;; Permet de concatner les lments successifs d'un path menant  un fichier.
;; Un premier argument doit tre un PATH racine. Au moins un autre argument.
;; Le rsultat est un nom de FICHIER sous forme de path.
;; Exemples :
;;   <1> (cat-pathnames
;;         (make-pathname :directory "RACINE:truc") "Dos1" "Dos2" "Fic")
;;           => #P"RACINE:truc:Dos1:Dos2:Fic"
;;   <2> Si DirLocArsCombi est dfini comme #P"DD:DLO:cl.d:clce.d:ArsCombi.d:*",
;;       (cat-pathnames DirLocArsCombi "aaaa" "bbbb" "cccc")
;;           => #P"DD:DLO:cl.d:clce.d:ArsCombi.d:aaaa:bbbb:cccc"
(defun cat-pathnames (depart &rest frags)
  (labels ((interne (frgs ldr)
;(dbg ldr)
            (if (endp (cdr frgs))
              (merge-pathnames (car frgs) ldr)
            (interne (cdr frgs)
                     (merge-pathnames 
                      (make-pathname
                       :directory
                       (namestring (merge-pathnames (car frgs) ldr)))
                      "*")))))
  (interne frags depart)))