;; Pour justifier la marge droite  d'un texte, en augmentant le nombre d'espaces
;; blancs entre les mots. 
;;  Appel : (justif "<chane de caratres>" &key :largeur (<n> 77))
;; Les ventuels ";;" sont limins  de la chane originelle.  Evidemment, on ne
;; sait pas traiter de " dans la chane ! 
;; Largeur finale par dfaut : 80 = 77 + ";; " en dbut de chaque ligne.
;; Les commentaires de ce fichier ont t traits avec la fonction justif.

;; Cf. separer-mots.cl.
;; A  partir d'une   chane de caractres, donne   une liste de sous-chanes, ou
;; <mots>. Un <mot>  est compos d'un  ou plusieurs  caractres non-sparateurs,
;; spars par un ou plusieurs  caractres sparateurs. Le mot-clef :separateurs
;; permet de modifier la liste des caractres dfinis comme sparateurs.
;; Ex. : (separer-mots "    ")                   ==> nil
;;       (separer-mots " C'est lui ! Non ? ")    ==> ("C" "est" "lui" "Non")
(defun separer-mots (cadena
     &key (separateurs
               '(#\space #\newline #\tab #\return #\linefeed #\page ;blancs
                ))  )
  (do ( (rez    ()                    )
        (mot    ""                    )
        (caract nil                   )
        (long   (length cadena)       )
        (n      0               (1+ n)) )
      ( (= n long) (if (string= "" mot) rez
                       (append rez (list mot))) )
    (if (member (setq caract (char cadena n)) separateurs)
      (when (not (string= "" mot))
        (setq rez (append rez (list mot)))
        (setq mot ""))
      (setq mot (concatenate 'string mot (string caract))))))

(defun justif (chaine &key (largeur 77)
                        &aux listmots
                             listmtslgn ;... mots d'1 ligne
                             listesplgn ;... longueurs des espaces d'1 ligne
                             (lnglgn 0) ;longueur d'1 ligne
                             (lngtmp 0) ;longueur d'1 ligne pour essayer...
                             mot        ;un mot
                 )
  (setq listmots (remove ";;" (separer-mots chaine) :test #'equal))
  (labels ((interne (liste)
             (if (endp liste) (if (endp listmtslgn) 'ok
                              ( progn (imprimer listmtslgn
                                                listesplgn
                                                lnglgn
                                                largeur
                                                :justifier nil)
                                      'ok))
             (progn (setq mot (car liste))
                    (setq listmtslgn (append listmtslgn (list mot)))
                    (incf lngtmp (length mot))
                    (when (car liste) (setq listesplgn (append listesplgn '(1)))
                                      (incf lngtmp))
                    (if (<= lngtmp largeur) (progn (pop liste)
;(dbg liste)
                                                   (setq lnglgn lngtmp)
                                                   (interne liste))
                    (progn (imprimer (butlast listmtslgn)
                                     (butlast listesplgn 2)
                                     (1- lnglgn)
                                     largeur
                                     :justifier t)
                           (setq listmtslgn nil)
                           (setq listesplgn nil)
                           (setq lnglgn (setq lngtmp 0))
                           (interne liste)))))))
    (interne listmots))
)

;; Pour ajuster la  longueur  d'une  ligne et l'imprimer. Appel  avec :justifier
;; nil  si l'on  n'a pas pas  besoin de justifier  -- dans le cas d'une dernire
;; ligne incomplte. 
(defun imprimer (mots espaces largact largfin &key (justifier t)
                                              &aux nbrespas
                )
  (setq nbrespas (list-length espaces))
;(format t "=============================~%")
;(dbg mots)
;(dbg espaces)
;(dbg largact)
;(dbg largfin)
;(dbg justifier)
;(dbg nbrespas)
  (when justifier (dotimes (n (- largfin largact))
                    (let ((pt (nthcdr (random nbrespas) espaces)))
                      (rplaca pt (1+ (car pt))))))
;(dbg espaces)
;(format t "largeur finale des espaces = ~D~%" (apply #'+ espaces))
  (format t ";; ")
  (labels ((interne (lesmots)
             (if (endp lesmots) (format t "~%")
             (progn (format t "~A" (car lesmots))
                    (when espaces (dotimes (n (pop espaces))
                                    (format t " ")))
                    (interne (cdr lesmots))))))
    (interne mots))
)

(format t "~2%Faire : (justif <chaine>).~2%")

