;;; Ne PAS charger !!!
;;; Tests et dmonstrations  valuer manuellement

;;; Rgler au besoin *rall* = longueur de la boucle de ralentissement
;;; d'affichage, au moyen de la fonction rall :
;;;    (rall <b> <e>) => (setq *rall* (* <b> (expt 10 <e>)))  ;b*(10^e)
;;; N.B. : *rall* = 1000000 par dfaut quiv.  (rall 1 6), pour les
;;; premiers exemples de petites configurations priodiques

;;   La variable globale *fen* dsigne la fentre d'affichage du tableau
;; lebensraum. Elle n'est pas transmise par les appels ci-dessous.
;; Procdure normale :
;;    - librer tableau lebensraum et afficher *fen* vide : (vide-lebensraum)
;;    - placer configuration(s) dans etat 0 du tableau lebensraum. Par ex. :
;;        (place <c> <l> <config>) ou
;;        (lifep "<fichier>")      ou
;;        (configalea <n>)         etc.
;;    - afficher la configuration de dpart : (affiche)
;;    - lancer <n> gnrations avec affichage : (evolution <n>)

;; N.B. L'espace de COLONS x LIGNES cellules reprsent par la fentre *fen* est
;; un *tore*.

;;; Configurations priodiques

; Barre horizontale longueur 3
(setq barre-h-3 '((0 . 0) (1 . 0) (2 . 0)))
; Barre verticale longueur 3
(setq barre-v-3 '((0 . 0) (0 . 1) (0 . 2)))
(progn (vide-lebensraum)(place 40 26 barre-h-3)
       (place 52 25 barre-v-3)(affiche)(evolution 9))
; 2 de chacune des prcdentes barres arranges en cercle-croix
(setq cercle-croix '((1 . 0) (2 . 0) (3 . 0)
                     (0 . 1) (0 . 2) (0 . 3)
                     (4 . 1) (4 . 2) (4 . 3)
                     (1 . 4) (2 . 4) (3 . 4)))
; Les mmes en arrangement swastika
(setq swastika1 '((0 . 0)(1 . 0)(2 . 0)(5 . 0)
                 (5 . 1)
                 (5 . 2)
                 (0 . 3)
                 (0 . 4)
                 (0 . 5)(3 . 5)(4 . 5)(5 . 5)))
(progn (vide-lebensraum)(place 43 26 swastika1)
                        (place 20 20 cercle-croix)
                        (affiche) (evolution 9))
; Les mmes plus serres => configuration s'anantissant
(setq swastika2 '((0 . 0)(1 . 0)(2 . 0)(4 . 0)
                 (4 . 1)
                 (0 . 2)(4 . 2)
                 (0 . 3)
                 (0 . 4)(2 . 4)(3 . 4)(4 . 4)))
(progn (vide-lebensraum)(place 43 26 swastika2)(affiche)(evolution 9))

;;; Configurations fixes (cf. aussi lifep:STILL.LIF ci-dessous !)

; Carr 2x2
(setq carre2x2 '((0 . 0) (1 . 0) (0 . 1) (1 . 1)))
; Diverses
(setq fixdiv01 '((1 . 0) (0 . 1) (2 . 1) (0 . 2) (2 . 2) (1 . 3)))
(setq fixdiv02 '((1 . 0) (2 . 0) (0 . 1) (3 . 1) (1 . 2) (2 . 2)))
(setq fixdiv03 '((0 . 0) (1 . 0) (0 . 1) (2 . 1) (1 . 2) (2 . 2)))
(setq fixdiv04 '((1 . 0) (2 . 0) (0 . 1) (2 . 1) (0 . 2) (1 . 2)))
(setq fixdiv05 '((1 . 0) (0 . 1) (2 . 1) (1 . 2) (3 . 2) (2 . 3)))
(setq fixdiv06 '((2 . 0) (1 . 1) (3 . 1) (0 . 2) (2 . 2) (1 . 3)))
(setq fixdiv07 '((1 . 0) (2 . 0) (0 . 1) (3 . 1) (1 . 2) (4 . 2) (2 . 3) (3 . 3)))
(setq fixdiv08 '((2 . 0) (1 . 1) (3 . 1) (0 . 2) (3 . 2) (1 . 3) (2 . 3)))
(progn (vide-lebensraum)(place 20 10 carre2x2)
                        (place 30 10 fixdiv01)
                        (place 40 10 fixdiv02)
                        (place 50 10 fixdiv03)
                        (place 60 10 fixdiv04)
                        (place 25 30 fixdiv05)
                        (place 35 30 fixdiv06)
                        (place 45 30 fixdiv07)
                        (place 55 30 fixdiv08)                       
                        (affiche))
(evolution 5)

;;; Configurations alatoires 

; Dpart avec lebensraum vide
(progn (vide-lebensraum)(config-alea 350) (affiche))
; Rpter ventuellement ceci plusieurs fois pour ajouter chaque fois des points 
; l'tat 0. Un appel cre/ajoute N <= 350 cellules occupes
(progn (config-alea 350) (affiche))
; Lancer 50 gnrations
(evolution 50)

;;; Configurations gomtriques

; Horizontales "Broadway"
(let (l)
  (vide-lebensraum)
  (dotimes (n 8) (setq l (* 2 n)) (droite 0 l (1- COLONS) l))
  (affiche))
(evolution 50)

; Une seule horizontale... envahissante !
(progn (vide-lebensraum)
       (droite 4 30 86 30)
       (affiche))
(evolution 200)

; Croix semble ternelle, gnre des *gliders*
(progn (vide-lebensraum)
       (droite 4 27 86 27) (droite 45 4 45 52)
       (affiche))
(evolution 200)

; Verticales "Broadway"
(let (l)
  (vide-lebensraum)
  (dotimes (n 8) (setq l (* 2 n)) (droite l 0 l (1- LIGNES)))
  (affiche))
(evolution 50)

; Verticales... Evolutions trs diffrentes selon longueur !
; Mme si survie, passent souvent prs de l'extinction / ptrification...
; Testes dans un lebensraum de 91 colonnes x 57 lignes
(let (c)           ;mini => extinction immdiate
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 26 c (- LIGNES 31)))
  (affiche))
(evolution 1)
(let (c)           ;mini => statique en 2 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 25 c (- LIGNES 29)))
  (affiche))
(evolution 4)
(let (c)           ;un peu plus longues => extinction en 6 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 23 c (- LIGNES 27)))
  (affiche))
(evolution 6)
    (let (c)           ;diffrent si transversale ; fin statique
      (vide-lebensraum)
      (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 23 c (- LIGNES 27)))
      (droite 25 31 63 31)
      (affiche))
    (evolution 78)
        (let (c)           ;statique plus vite si deux transversales
          (vide-lebensraum)
          (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 23 c (- LIGNES 27)))
          (droite 25 31 63 31)
          (droite 25 23 63 23)
          (affiche))
    (evolution 50)
        (let (c)           ;statique/priodique plus vite si trois transversales
          (vide-lebensraum)
          (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 23 c (- LIGNES 27)))
          (droite 25 31 63 31)
          (droite 25 27 63 27)
          (droite 25 23 63 23)
          (affiche))
    (evolution 40)
(let (c)           ;un peu plus longues => statique en 7 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 21 c (- LIGNES 25)))
  (affiche))
(evolution 10)
(let (c)           ;plus => ... espoir... mais statique en 55 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 19 c (- LIGNES 23)))
  (affiche))
(evolution 55)
(let (c)           ;plus => stat. en 20 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 17 c (- LIGNES 21)))
  (affiche))
(evolution 20)
(let (c)           ;plus => cyclique en 35 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 15 c (- LIGNES 19)))
  (affiche))
(evolution 35)
(let (c)           ;plus => statique en 23 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 13 c (- LIGNES 17)))
  (affiche))
(evolution 23)
(let (c)           ;plus => statique et cyclique en 60 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 11 c (- LIGNES 15)))
  (affiche))
(evolution 62)
(let (c)           ;plus => statique en 64 gn.
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 9 c (- LIGNES 13)))
  (affiche))
(evolution 65)
(let (c)           ;plus => toujours vivante aprs 400 gnrations <<<<<<<<<<<<
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 7 c (- LIGNES 11)))
  (affiche))
(evolution 400)
(let (c)           ;plus => statique et cyclique en 74 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 5 c (- LIGNES 9)))
  (affiche))
(evolution 75)
(let (c)           ;plus => statique et cyclique en 198 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 3 c (- LIGNES 4)))
  (affiche))
(evolution 200)
(let (c)           ;maxi-1 => statique et cyclique en 222 gnrations
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 1 c (- LIGNES 2)))
  (affiche))
(evolution 225)
(let (c)           ;maxi => ternelles, cf. "Broadway" ci-dessus
  (vide-lebensraum)
  (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 0 c (- LIGNES 1)))
  (affiche))
(evolution 100)
    (let (c)           ;autre monde si 1 transversale, stat. & cycl.  85
      (vide-lebensraum)
      (dotimes (n 20) (setq c (+ (* 2 n) 25)) (droite c 0 c (- LIGNES 1)))
          (droite 0 28 90 28)
      (affiche))
    (evolution 93)

; Diagonales
; Une seule ne peut survivre
(progn (vide-lebensraum) (droite 34 15 54 35) (affiche))
(evolution 10)
; Charg : la vie prend le dessus
(progn (vide-lebensraum) (droite 4 0 1067 1063) (affiche))
(evolution 200)
; Plus charg : le vide s'instaure
(progn (vide-lebensraum)
       (droite 4 0 1086 1082) (droite 0 84 1067 1063)
       (affiche))
(evolution 225)

;;; Configuration "classiques" connues
;; Cf. aussi collection de 174 configuration compile par Alan Hensel (dossier
;; adjacent lifep, obtenu de http://cafaq.com/lifefaq/index.php > lifep.zip)

;; Configurations croissantes

; Cf. lifep.zip:ACORN.LIF
(setq acorn '((1 . 0)(3 . 1)(0 . 2)(1 . 2)(4 . 2)(5 . 2)(6 . 2)))
(progn (vide-lebensraum)(place 53 26 acorn)(affiche))
(evolution 150)
; Cf. lifep.zip:RABBITS.LIF
(setq rabbits '((0 . 0)(4 . 0)(5 . 0)(6 . 0)
                (0 . 1)(1 . 1)(2 . 1)(5 . 1)
                (1 . 2)))
(progn (vide-lebensraum)(place 53 26 rabbits)(affiche))
(evolution 150)
; Cf. lifep.zip:PI.LIF : symtrique
(setq pi-vie '((0 . 0)(1 . 0)(2 . 0)(0 . 1)(2 . 1)(0 . 2)(2 . 2)))
(progn (vide-lebensraum)(place 43 26 pi-vie)(affiche))
(evolution 100)

;; Configurations se dplaant  l'infini

;; *Gliders* (planeurs) ou "navires"

; glider01 : diagonale N-E => S-0
(setq glider01 '((1 . 0) (2 . 1) (0 . 2) (1 . 2) (2 . 2)))
; glider02 : diagonale S-O => N-E
(setq glider02 '((0 . 0) (1 . 0) (0 . 1) (0 . 2) (2 . 2)))
; glider03 : diagonale N-O => S-E
(setq glider03 '((1 . 0) (0 . 1) (0 . 2) (1 . 2) (2 . 2)))
; glider04 : diagonale S-E => N-0
(setq glider04 '((1 . 0) (2 . 0) (2 . 1) (0 . 2) (2 . 2)))
; Les 4 gliders prcdents placs au centre afin de se dplacer en divergeant
(let ((h (floor (/ COLONS 2))) (v (floor (/ LIGNES 2))))
  (vide-lebensraum)
  (place (- h 5) (- v 5) glider02)
  (place (1+ h)  (- v 5) glider04)
  (place (- h 5) (1+ v)  glider03)
  (place (1+ h)  (1+ v)  glider01)
  (affiche))
(evolution 50)
; 6 gliders se frlant puis divergeant trois  trois en rangs serrs
(let ((h (floor (/ COLONS 2))) (v (floor (/ LIGNES 2))))
  (vide-lebensraum)
  (place (+ h 3) (- v 3)
         '((2 . 0)
           (0 . 1)(1 . 1)(10 . 1)
           (1 . 2)(2 . 2)(6 . 2)(9 . 2)
           (5 . 3)(6 . 3)(9 . 3)(10 . 3)(11 . 3)
           (5 . 4)(7 . 4)))
  (place (- h 13) v
         '((4 . 0)(6 . 0)
           (0 . 1)(1 . 1)(2 . 1)(5 . 1)(6 . 1)
           (2 . 2)(5 . 2)(9 . 2)(10 . 2)
           (1 . 3)(10 . 3)(11 . 3)
           (9 . 4)))
  (affiche))
(evolution 30)
; Les mmes 6 *gliders* en parallle. Cf. lifep.zip:GLIDERS6.LIF
(progn (vide-lebensraum)(lifep "GLIDERS6")(affiche)) (evolution 40)

;; Gros *glider(s)*, existent dans les 4 directions (?)

; Gros *glider* : horizontale O => E
(setq gglider01 '((1 . 0)(2 . 0)(3 . 0)(4 . 0)(0 . 1)(4 . 1)(4 . 2)(0 . 3)(3 . 3)))
(progn(vide-lebensraum)(place 1 1 gglider01)(affiche)) (evolution 60)

; Traage de diagonales de *gliders* N-E <=> S-O
(let ((o1 '(0 . 0)) (o2 '(13 . 0)) (incr 10) (nbr 17) tmp)
  (vide-lebensraum)
  (dotimes (n nbr)
    (setq tmp (* n incr))
    (place (mod (+ (car o1) tmp) COLONS)
             (mod (+ (cdr o1) tmp) LIGNES)
             glider01)
    (place (mod (+ (car o2) tmp) COLONS)
             (mod (+ (cdr o2) tmp) LIGNES)
             glider02))
  (affiche))
(evolution 50)

; Diagonales N-O <=> S-E : explosions en vol, chaos, un seul survivant glider02
; dans un monde interstellaire quasi fig, aprs ca. 120 gnrations en 91x57...
; Puis les dexu zones de vie reprennent le dessus.
(let ((o1 '(0 . 0)) (o2 '(-13 . 7)) (incr -10) (nbr 17) tmp)
  (vide-lebensraum)
  (dotimes (n nbr)
    (setq tmp (* n incr))
    (place (mod (+ (car o1) tmp) COLONS)
             (mod (+ (cdr o1) tmp) LIGNES)
             glider03)
    (place (mod (+ (car o2) tmp) COLONS)
             (mod (+ (cdr o2) tmp) LIGNES)
             glider04))
  (affiche))
(evolution 120)

;; Combinaison  la fois priodique et gnrant des glider01 : *Glider Gun* de
;; Bill Gosper (cf. http://en.wikipedia.org/wiki/Image > Gospers_glider_gun.gif,
;; ci-joint).
;; Mme configuration dans lifep:GUN30.LIF => faire (lifep "GUN30")

(setq GliderGun '(
 (25 . 0)
 (22 . 1)(23 . 1)(24 . 1)(25 . 1)(30 . 1)
 (13 . 2)(21 . 2)(22 . 2)(23 . 2)(24 . 2)(30 . 2)
 (12 . 3)(14 . 3)(21 . 3)(24 . 3)(34 . 3)(35 . 3)
 (11 . 4)(15 . 4)(16 . 4)(21 . 4)(22 . 4)(23 . 4)(24 . 4)(34 . 4)(35 . 4)
 ( 0 . 5)( 1 . 5)(11 . 5)(15 . 5)(16 . 5)(22 . 5)(23 . 5)(24 . 5)(25 . 5)
 ( 0 . 6)( 1 . 6)(11 . 6)(15 . 6)(16 . 6)(25 . 6)
 (12 . 7)(14 . 7)
 (13 . 8)))
(progn(vide-lebensraum)(place 3 3 GliderGun)(affiche))
(evolution 430) => tout se passe normalement jusqu' ce que...
(evolution 100) ... un glider accroche le carr droit en 91x57 et...

;; Configurations compiles par Alan Hensel (cf. dossier lifep obtenu de
;; http://cafaq.com/lifefaq/index.php > lifep.zip). Sur les 174, seules sont
;; retenues ici celles qui entrent dans un espace de 91x57. Les autres sont trop
;; grandes (cf. lifep:00-LISMOI.txt), particulirement tous les fichiers
;; AQUAxxx.LIF ("aquariums"), les SAWTOOTx.LIF (*sawtooth*), le THUE.LIF
;; (malheureusement !), etc. Appel type :
;;    (progn(vide-lebensraum)(lifep "<xx>")(affiche)) (evolution <n>)

;; Priodiques

; Nombreux oscillateurs "OSC..." dans dossier lifep, mais trop grands pour 91x57
; Dfilant sur place
(progn (vide-lebensraum)(lifep "EFENCE")(affiche)) (evolution 45)
(progn (vide-lebensraum)(lifep "ZIP2")(affiche)) (evolution 35)
; Aussi effet dfilant
(progn (vide-lebensraum)(lifep "POLES")(affiche)) (evolution 45)
; Fixes
(progn (vide-lebensraum)(lifep "QUILT")(affiche)) (evolution 25)
(progn (vide-lebensraum)(lifep "ROT8")(affiche)) (evolution 35)
(progn (vide-lebensraum)(lifep "VENETIA2")(affiche)) (evolution 30)
(progn (vide-lebensraum)(lifep "VENETIA3")(affiche)) (evolution 30)
; 2 cte  cte
(progn (vide-lebensraum)(lifep "TWINDOTS")(affiche)) (evolution 20)

;; Priodiques gnrant des *gliders*

; Le premier est le *Glider Gun* le plus connu de Bill Gosper (cf. ci-dessus)
(progn (vide-lebensraum)(lifep "GUN30")(affiche)) (evolution 110)
; D'autres sont aussi de lui...
(progn (vide-lebensraum)(lifep "AK47")(affiche)) (evolution 100)
(progn (vide-lebensraum)(lifep "BI-GUN")(affiche)) (evolution 150)
(progn (vide-lebensraum)(lifep "GUN44")(affiche)) (evolution 160)
(progn (vide-lebensraum)(lifep "GUN46")(affiche)) (evolution 110)
(progn (vide-lebensraum)(lifep "GUN104")(affiche)) (evolution 260)
; Celui-ci s'auto-dtruit en bas  gauche en 91x57
(progn (vide-lebensraum)(lifep "GUN132")(affiche)) (evolution 200)
(progn (vide-lebensraum)(lifep "GUN144")(affiche)) (evolution 300)
; Effets "billard"...
(progn (vide-lebensraum)(lifep "GUN184")(affiche)) (evolution 250)
(progn (vide-lebensraum)(lifep "GUN246")(affiche)) (evolution 230)
(progn (vide-lebensraum)(lifep "GUNB256")(affiche)) (evolution 300)
; Effet billard *pinball* (= "flipper"  la franaise) : les *gliders* restent
; enferms dans un primtre
; Hauteur 57 = juste assez pour celui-ci !
(progn (vide-lebensraum)(lifep "PINBALL")(affiche)) (evolution 260)
(progn (vide-lebensraum)(lifep "RACE")(affiche)) (evolution 175)
(progn (vide-lebensraum)(lifep "RELAY")(affiche)) (evolution 120)
; Effet "billard" avec gros *gliders*
(progn (vide-lebensraum)(lifep "LWSSGUN")(affiche)) (evolution 200)
; 8 *gliders* crant par collisions le *Glider Gun* de B. Gosper !!!
(progn (vide-lebensraum)(lifep "MAKEGUN")(affiche)) (evolution 150)
; Gnre des gros et petits *gliders* (un peu grande pour 91x57, mais a va...)
(progn (vide-lebensraum)(lifep "MWSSGUN")(affiche)) (evolution 200)
; 2 oscillateurs parallles, gnrant des *gliders* prisonniers
(progn (vide-lebensraum)(lifep "THINGUN2")(affiche)) (evolution 120)
(progn (vide-lebensraum)(lifep "THINGUN3")(affiche)) (evolution 150)
; 4 oscillateurs parallles, gnrant des *gliders* => S-E
(progn (vide-lebensraum)(lifep "THICKGU2")(affiche)) (evolution 150)

;; Apriodiques gnrant des *gliders*

(progn (vide-lebensraum)(lifep "BHEPTO")(affiche)) (evolution 150)

;; Collection de configurations fixes !

(progn (vide-lebensraum)(lifep "STILL")(affiche)) (evolution 20)

;; Prolifrantes

(progn (vide-lebensraum)(lifep "ACORN")(affiche)) (evolution 100)
(progn (vide-lebensraum)(lifep "RABBITS")(affiche)) (evolution 100)
;  partir de presque rien, prolifre en gnrant des *gliders* et finit par
;devenir statique/priodique
(progn (vide-lebensraum)(lifep "RPENTO")(affiche)) (evolution 900)

; La plus prolifrante, pavant l'espace (limite  max. 30 gnrations en 91x57)
(progn (vide-lebensraum)(lifep "MAX")(affiche)) (evolution 30)
; Variantes pavant l'espace (limites au max. de gnrations en 91x57)
(progn (vide-lebensraum)(lifep "MAX2")(affiche)) (evolution 32)
(progn (vide-lebensraum)(lifep "MAX3")(affiche)) (evolution 30)

;; S'anantissant

; Collisions de *gliders*
(progn (vide-lebensraum)(lifep "MIRAGE")(affiche)) (evolution 74)

;; Se dplaant

(progn (vide-lebensraum)(lifep "BSHIP")(affiche))  (evolution 100)
(progn (vide-lebensraum)(lifep "BSHIP2")(affiche)) (evolution 110)
; Vols de canards => O
(progn (vide-lebensraum)(lifep "LWSSRAK2")(affiche)) (evolution 60)
(progn (vide-lebensraum)(lifep "LWSSRAKE")(affiche)) (evolution 100)
; Gros et petits *gliders* voluant ensemble (un peu juste pour 91x57 mais OK...)
(progn (vide-lebensraum)(lifep "MWSSRAK2")(affiche)) (evolution 100)
; idem
(progn (vide-lebensraum)(lifep "MWSSRAKE")(affiche)) (evolution 75)
; Des *gliders* parallles etc. => N-O
(progn (vide-lebensraum)(lifep "WING")(affiche)) (evolution 100)
; => O
(progn (vide-lebensraum)(lifep "SLOPUF2")(affiche)) (evolution 140)
; => N-O laissant une trace derrire elle
(progn (vide-lebensraum)(lifep "TIRETRAK")(affiche)) (evolution 100)
; Semblable  deux traces, dont une avale par une autre configuration => N-O
(progn (vide-lebensraum)(lifep "TIRETRAX")(affiche)) (evolution 90)
; Trs bizarre ! => N-O, laissant derrire elle des carrs 2x2
(progn (vide-lebensraum)(rall 1 5)(lifep "SWITCHEN")(affiche)) (evolution 666)

;; Se dplaant en gnrant des *gliders*

(progn (vide-lebensraum)(lifep "COERAKE1")(affiche))(evolution 110)
(progn (vide-lebensraum)(lifep "COERAKE2")(affiche))(evolution 100)
(progn (vide-lebensraum)(lifep "RAKE")(affiche)) (evolution 175)
; Finit par devenir fixe/priodique
(progn (rall 1 5)(vide-lebensraum)(lifep "RAKE2")(affiche)) (evolution 1100)

;; Se figeant...

(progn (vide-lebensraum)(lifep "EATERS")(affiche)) (evolution 200)
(progn (vide-lebensraum)(lifep "EDEN")(affiche)) (evolution 145)
; Cf. pi-vie ci-dessus : se fige en configurations fixes et oscillantes
(progn (vide-lebensraum)(lifep "PI")(affiche)) (evolution 185)
; Se dplace en avalant tout, jusqu' fin sur oscillation cercle-croix
(progn (vide-lebensraum)(lifep "TNDRBIRD")(affiche)) (evolution 133)

;; S'tirant graduellement

; Cf. oscillateur "EFENCE" ci-dessus
(progn (vide-lebensraum)(lifep "STRETCH")(affiche)) (evolution 115)
; Gros *gliders* => E, laissant des configurations oscillantes derrire eux
(progn (vide-lebensraum)(lifep "PSRTRAIN")(affiche)) (evolution 135)
; Gros *gliders* => E, laissant des "bouffes" derrire eux
(progn (vide-lebensraum)(lifep "PUFTRAIN")(affiche)) (evolution 150)

;;; Tests manuels

; Lancement de 50 gnrations avec affichage.
(evolution 50)

(vide-lebensraum)
(progn (affiche) (generation))

;; Deux tentatives de copier des configurations  partir d'illustrations
;; agrandies de l'article de J.-P. Delahaye pp. 94-95 (rfrence dans JeuVie.cl).
;; Pas assez prcises ; ne marchent pas. Elles sont heureusement toutes deux dans
;; la collection d'Alan Hensel : l'une dans lifep:STRETCH.LIF, l'autre dans
;; lifep:MAX.LIF
